<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Craftsman\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of craftsman service
 *
 * @method ResultInterface deferGetCraftsmenList(int $storeId, int $subStoreId = 0, int $itemId = 0)
 * @method ResultInterface deferGetCraftsmenByUnionId(string $unionId, int $isSeller=0)
 * @method ResultInterface defercreateCraftsman($storeId, array $params)
 * @method ResultInterface deferGetCraftsmenById(int $storeId, int $cmanId)
 * @method ResultInterface deferGetCraftsmenByIds(int $storeId, array $cmanIds)
 * @method ResultInterface deferSyncItems(int $storeId, array $itemIds, int $mode)
 * @method ResultInterface deferUpdateCmanByUnionId(string $unionId, int $storeId, array $data)
 */
interface CraftsmanInterface
{
    // 店员服务的字段说明：
    // name       店员名字
    // sex        性别
    // mobile     店员手机
    // inReview   审核状态，1审核中，2审核通过
    // headimg    店员头像
    // items      服务项目id列表，逗号隔开
    // subStores  子店铺id列表，逗号隔开
    // motto      个人签名
    // adept      个人擅长说明
    // wechat     店员微信号

    /**
     * 创建店员
     *
     * @param integer $storeId
     * @param array $params 所需参数
     *array(
     * 'name'    => '', // 姓名
     * 'sex'     => '', // 性别
     * 'wxNick'  => '', // 昵称
     * 'headimg' => '', // 头像
     * 'items'   => '', // 包含的服务项目列表
     * 'subStores' => '', // 所属门店列表
     * 'motto'   => '', // 个性签名
     * 'adept'   => '', // 个人擅长
     * 'wechat'  => '', // 微信号
     *)
     * @return int|bool
     */
    public function createCraftsman($storeId, array $params);

    /**
     * 获取店员列表
     *
     * @param integer $storeId
     * @param integer $subStoreId  子店铺Id
     * @param integer $itemId      服务项目（商品）id
     *
     * @return array
     */
    public function getCraftsmenList(int $storeId, int $subStoreId = 0, int $itemId = 0);

    /**
     * 根据unionId获取店员信息
     *
     * @param string $unionId
     * @param int $isSeller   是否店主 1-是 ，0-否 
     * @return array
     */
    public function getCraftsmenByUnionId(string $unionId, int $isSeller =0);

    
    /**
     * 根据店铺Id和店员Id获取店员信息
     *
     * @param integer $storeId
     * @param integer $cmanId
     * @return array
     */
    public function getCraftsmenById(int $storeId, int $cmanId);

    /**
     * 根据店铺Id和店员Id列表获取店员列表
     *
     * @param integer $storeId
     * @param array $cmanIds
     * @Number(name="storeId")
     * @return array
     */
    public function getCraftsmenByIds(int $storeId, array $cmanIds);

    /**
     * 提供给商品服务，用来同步店员所属的商品
     *
     * @param integer $storeId
     * @param array $itemIds
     * @param integer $mode 取值：1 表示新增，2 表示去除
     * @return boolen
     */
    public function syncItems(int $storeId, array $itemIds, int $mode);

    /**
     * 根据unionId修改在指定店铺的店员信息
     *
     * @param string  $unionId
     * @param integer $storeId
     * @param array $data
     * @return mixed
     */
    public function updateCmanByUnionId(string $unionId, int $storeId, array $data);

}