<?php

namespace Hdll\Services\Logistics\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferOnPath(array $param)
 * @method ResultInterface deferHandleFreight($storeId, array $receiver, array $goods)
 * Class LotteryInterface
 * @package Hdll\Services\Logistics\Lib
 */
interface LogisticsInterface
{

	public function onPath(array $param);


	public function imOnPath(array $param);

	/**
	 * 获取运费
	 * @param       $storeId
	 * @param array $receiver
	 * @param array $goods
	 * @return mixed
	 */
	public function handleFreight($storeId, array $receiver, array $goods);

	/**
	 * 获取收货人地址
	 * @param $id
	 * @param $storeId
	 * @return mixed
	 */
	public function getReceiver($id, $storeId);
}