<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Schedule\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of Schedule service
 *
 * @method ResultInterface deferGetScheduleList(int $storeId, int $month, int $cmanId = 0)
 * @method ResultInterface deferGetScheduleByDateId(int $storeId, int $dateId, int $cmanId = 0)
 * @method ResultInterface deferUpdateSchedule(int $storeId, int $cmanId, int $dateId, array $data)
 * @method ResultInterface deferAddSchedule(int $storeId, int $cmanId, int $dateId, array $data)
 */
interface ScheduleInterface
{
    /**
     * 获取店铺所有日程列表
     *
     * @param integer $storeId
     * @param integer $month 指定要查哪个月份的日程列表，格式如：201810
     * @return array 空数组表示没有查询到记录
     */
    public function getScheduleList(int $storeId, int $month, int $cmanId = 0);

    /**
     * 获取某天的日程信息
     *
     * @param integer $storeId
     * @param integer $dateId  要查询的日期id，格式要求如：20180803 
     * @param integer $cmanId  手艺人ID，可查询指定手艺人的日程安排，为0时表示店铺级别的日程
     * @return array 空数组表示没有查询到记录
     */
    public function getScheduleByDateId(int $storeId, int $dateId, int $cmanId = 0);

    /**
     * 根据dateId修改某个日程的信息
     *
     * @param integer $storeId
     * @param integer $cmanId  手艺人ID，可修改指定手艺人的日程安排，$cmanId==0 时表示修改店铺级别的日程
     * @param integer $dateId  要修改的日期id，格式要求如：20180803 
     * @param array $data
     * 参数 $data 字段说明：
     * ['offday'] => 是否是休息日，0不是，1是
     * 
     * @return int  成功更新的条数
     */
    public function updateSchedule(int $storeId, int $cmanId, int $dateId, array $data);

    /**
     * 添加一个日程安排
     *
     * @param integer $storeId
     * @param integer $cmanId  手艺人ID，给指定的手艺人添加日程安排，$cmanId==0 时表示添加店铺级别的日程
     * @param integer $dateId  要添加的日期id，格式要求如：20180803 
     * @param array $data
     * 参数 $data 字段说明：
     * ['offday'] => 是否是休息日，0不是，1是
     * 
     * @return int 
     */
    public function addSchedule(int $storeId, int $cmanId, int $dateId, array $data);
    
}