<?php
namespace Hdll\Services\Common\Config;
use Swoft\Redis\Redis;
use Swoft\App;

class CfgCenter
{

    /**
     * 读取指定的配置项 - 返回对象格式
     * (所有配置项，需预先添加到数据库中)
     * 方法一：
     *  $value = CfgCenter::get('qCloud>Weapp>Region');
     *  var_dump($value); // 输出：ap-shanghai
     * 方法二：
     *  $cfgdata = CfgCenter::get('qCloud');
     *  var_dump($cfgdata->Weapp->Region); // 输出：ap-shanghai
     * 
     * @param string $keyStr
     * @param string $default 默认返回值
     * @return mixed
     */
    public static function get($keyStr, $default='')
    {
        $data = self::_get($keyStr);
        if($data == '') {
            return $default;
        }
        return $data;
    }

    /**
     * 读取指定的配置项 - 返回数组格式
     * (所有配置项，需预先添加到数据库中)
     * 方法一：
     *  $value = CfgCenter::get('qCloud>Weapp>Region');
     *  var_dump($value); // 输出：ap-shanghai
     * 方法二：
     *  $cfgdata = CfgCenter::get('qCloud');
     *  var_dump($cfgdata['Weapp']['Region']); // 输出：ap-shanghai
     * 
     * @param string $keyStr
     * @param string $default 默认返回值
     * @return mixed
     */
    public static function getArray($keyStr, $default='')
    {
        $data = self::_get($keyStr);
        if($data == '') {
            return $default;
        }
        if(is_object($data)) {
            return json_decode(json_encode($data), true);
        }
        return $data;
    }

    private static function _get($keyStr)
    {
        $keyArr = self::parseKeyStr($keyStr);
        $rkey = implode(":", $keyArr);
        $redis = App::getBean(Redis::class);
        $data = $redis->get("CONFIG_CENTER:".$rkey);
        if($data === null) {
            $res = self::dbFetch($keyStr);
            if($res) {
                if(is_object($res[1])) {
                    $val = json_encode($res[1]);
                } else {
                    $val = $res[1];
                }
                $redis->set("CONFIG_CENTER:".$res[0], $val, 3600);
                return $res[1];
            }
        }
        $obj = json_decode($data);
        if($obj && is_object($obj)) {
            return $obj;
        }
        return $data;
    }

    protected static function dbFetch($keyStr)
    {
        $keyArr = self::parseKeyStr($keyStr);
        $name = array_shift($keyArr);
        $dbConn = self::dbConnect();
        $result = $dbConn->select("config", ['name','value'], ['name'=>$name]);
        if(!isset($result[0]['value'])) {
            return;
        }
        $valObj = json_decode($result[0]['value']);
        if(!is_object($valObj)) {
            return [$name, $result[0]['value']];
        }
        $keys = '';
        foreach($keyArr as $key) {
            if(!isset($valObj->$key)) {
                return;
            }
            $keys .= $key.':';
            $valObj = $valObj->$key;
        }
        $rkey = $name.':'.trim($keys,':');
        return [trim($rkey,':'), $valObj];
    }

    public static function dbConnect()
    {
        if(\env('ENVIRONMENT', '') == '') {
            // 返回线上数据库连接
            return new \Medoo\Medoo([
                'database_type' => 'mysql',
                'database_name' => 'config_center',
                'server' => '172.21.0.12',
                'username' => 'configer',
                'password' => 'Cfgsu#2390f*_',
                'charset' => 'utf8'
            ]);
        } elseif(\env('ENVIRONMENT', '') == 'pre') {
            // 返回测试数据库连接
            return new \Medoo\Medoo([
                'database_type' => 'mysql',
                'database_name' => 'config_center',
                'server' => '192.168.3.201',
                'username' => 'hdller',
                'password' => 'Hdlltest999',
                'charset' => 'utf8'
            ]);            
        } else {
            // 返回测试数据库连接
            return new \Medoo\Medoo([
                'database_type' => 'mysql',
                'database_name' => 'config_center',
                'server' => '192.168.3.202',
                'username' => 'hdller',
                'password' => 'Hdlltest888',
                'charset' => 'utf8'
            ]);
        }
    }

    protected static function parseKeyStr($keyStr)
    {
        $keyArr = explode(">", trim($keyStr, '>'));
        foreach($keyArr as $k => $v) {
            $v = trim($v);
            if($v == "") {
                unset($keyArr[$k]);
            } else {
                $keyArr[$k] = $v;
            }
        }
        if(empty($keyArr)) {
            throw new \Exception("[CfgCenter]未指定合法的Key");
        }
        return $keyArr;
    }
}

