<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\MemberCard\Lib;

use Swoft\Core\ResultInterface;


/**
 * The interface of demo service
 *
 * @method  ResultInterface deferGetWxMsg(array $msgArr)
 * @method ResultInterface deferPayOrder(int $storeId,string $orderSn,int $payStatus)
 * @method ResultInterface deferGetOrder(int $storeId,int $id)
 * @method ResultInterface deferGetOrderBySn(int $storeId,string $sn)
 * @method ResultInterface deferIfUserGetCard(int $storeId,int $userId,int $escrow)
 * @method ResultInterface deferGetUserCouponDetail(int $storeId ,int $couponId)  
 * @method ResultInterface deferSetUserCouponStatus(int $storeId,int $couponId,int $status)
 * @method ResultInterface deferGetUserValidCouponNum(int $storeId,int $escrow,int $userId)
 * @method ResultInterface deferIfCouponSuitOrder(int $storeId,int $userId,int $couponId,array $goods)
 * @method ResultInterface deferUpMembercardBonus(int $storeId,int $userId,int $orderId,int $type,int $money=0,int $bonus=0)
 * @method ResultInterface deferUpMembercardBalance(int $storeId,int $escrow,int $userId,int $balance)
 * @method ResultInterface deferGetBonusConvertMoney(int $storeId,int $userId,int $bonusToUse)
 * @method ResultInterface deferVerifyBonusConvertMoney(int $storeId,int $userId,int $bonusToUse,int $price)
 * @method ResultInterface deferGetUserBonus(int $storeId,int $userId)
 */
/**
 * The interface of demo service
 *
 * @method  ResultInterface deferGetWxMsg(array $msgArr) 
 */
interface MemberCardInterface
{
   
    /**
     *接收微信消息事件
     *
     * 
     * @param [array] $msgArr
     * @return int
     */
    public function getWxMsg(array $msgArr);


     /**
     * 支付订单(H5快速买单)
     * @param integer $storeId
     * @param string $orderSn
     * @param integer $payStatus
     * @return bool
     */
    public function payOrder(int $storeId,string $orderSn,int $payStatus);

      /**
     * 根据主键获取订单
     * @param integer $storeId
     * @param integer $id
     * @return array
     */
   
    public function getOrder(int $storeId,int $id);

     /**
     * 根据订单编号获取订单
     * @param integer $storeId
     * @param integer $sn
     * @return array
     */   
    public function getOrderBySn(int $storeId,string $sn);

  /**
   * 获取用户领卡状态：//0-没有卡 1-未领卡 2-领过了
   *
   * @param integer $storeId
   * @param integer $userId
   * @param integer $escrow
   * @return bool
   */
   public function ifUserGetCard(int $storeId,int $userId,int $escrow);

   /**
    * 查询优惠券详细信息
    *
    * @param integer $storeId
    * @param integer $couponId
    * @return void
    */
   public function getUserCouponDetail(int $storeId ,int $couponId);

   /**
    * 根据订单状态更改 优惠券的使用的相关状态
    *
    * @param integer $storeId
    * @param integer $couponId
    * @param integer $status
    * @return bool
    */
   public function setUserCouponStatus(int $storeId,int $couponId,int $status);

  /**
   * 获取用户未失效优惠券数量
   *
   * @param integer $storeId
   * @param integer $escrow
   * @param integer $userId
   * @return int
   */
   public function getUserValidCouponNum(int $storeId,int $escrow,int $userId);

    /**
   * 判断优惠券是否适用于订单（下单的时候调用）
   *
   * @param integer $storeId
   * @param integer $userId
   * @param integer $couponId
   * @param array $goods      [{goodsId:totalPrice},...]
   * @return bool
   */
  public function ifCouponSuitOrder(int $storeId,int $userId,int $couponId,array $goods);

  /**
   * 改变用户积分
   *
   * @param integer $storeId
   * @param integer $userId
   * @param integer $orderId
   * @param integer $type   //类型 1 消费产生积分 2 积分抵扣 3订单关闭 （这里只要传1-3)  枚举见 UpBonusEvent
   * @param integer $money  //类型1 只要传money，bonus不传；  类型2 money=0，bonus 传；   类型3 money，bonus都不传
   * @param integer $bonus
   * @return bool
   */
  public function upMembercardBonus(int $storeId,int $userId,int $orderId,int $type,int $money=0,int $bonus=0);

  /**
   * 用户储值卡余额 通知会员卡（显示在卡包 余额）
   *
   * @param integer $storeId
   * @param integer $escrow
   * @param integer $userId
   * @param integer $balance
   * @return bool
   */
  public function upMembercardBalance(int $storeId,int $escrow,int $userId,int $balance);

    /**
   * 下单时 查询 积分能抵扣的金额
   *
   * @param integer $storeId
   * @param integer $userId
   * @param integer $bonusToUse  
   * @return int  
   */
  public function getBonusConvertMoney(int $storeId,int $userId,int $bonusToUse);

   /**
   * 下单时 验证 积分能抵扣的金额
   *
   * @param integer $storeId
   * @param integer $userId
   * @param integer $bonusToUse
   * @param integer $price //订单原价减去优惠券后的价格
   * @return bool  //验证通过返回true，不通过返回false
   */
  public function verifyBonusConvertMoney(int $storeId,int $userId,int $bonusToUse,int $price);

  /**
   * 查询用户的会员卡积分
   *
   * @param integer $storeId
   * @param integer $userId
   * @return int
   */
  public function getUserBonus(int $storeId,int $userId);

}
