<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:49
 */
namespace Hdll\Services\Common\Entity;

use Swoft\App;
use Swoft\Core\RequestContext;
use Swoft\Db\Bean\Collector\EntityCollector;
use Swoft\Db\Model;
use Swoft\Exception\Exception;
use Swoole\Http\Request;

class CommonEntity extends Model
{

    private static $commentString;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();
        //分表逻辑
        $this->split();

        $this->init();

    }

    /**
     * 初始化
     */
    public function init()
    {

    }

    public static function getDb()
    {
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        //分表逻辑
        self::split();


        return new static;
    }

    /**
     * 设置分表表名
     * @throws Exception
     */
    protected function split()
    {
        if (  empty(RequestContext::getContextData()) ) {//初始化不做处理
            return;
        }


        if ( false === strpos(self::$commentString,"{split}") || App::$isInTest ) {
            return;
        }

        $dbNum = self::getDbNum();
        $tableName = self::getTableName();

        self::setTableName($tableName.'_'.$dbNum);

    }

    /**
     * 获取分库表名
     *
     * @return string|void
     * @throws Exception
     * @throws \ReflectionException
     */
    public static function tableName()
    {

        if (  empty(RequestContext::getContextData()) ) {//初始化不做处理
            return;
        }

        $request = RequestContext::getRequest();

        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        if ( false !== strpos(self::$commentString,"{split}") &&  !App::$isInTest) {
            $dbNum = self::getDbNum();
            $tableName = self::getTableName().'_'.$dbNum;
            self::setTableName($tableName);

            return $tableName;
        } else {
            return self::getTableName();
        }


    }

    /**
     * 获取数据库id
     * @return int
     * @throws Exception
     */
    private static function getDbNum()
    {
        $user = App::getBean(User::class);

        $store = $user->getStoreId();
        if ( $store === null && $store === [] && $store === '' ) {
            throw new Exception("店铺id获取失败");
        }

        return  $store % 100;

    }

    /**
     * 设置表名
     * @param $dbNum
     */
    protected static function setTableName($tableName)
    {
        EntityCollector::collect(
            static::class,
            new \Swoft\Db\Bean\Annotation\Table(['name' => $tableName])
        );

    }

    /**
     * 获取原始表名
     * @return string
     */
    protected static function getTableName()
    {
        preg_match('/(?<=Table\(name=").*(?="\))/', self::$commentString, $matches);
        return $tableName = isset($matches[0])?$matches[0]:'';
    }
}