<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\AccountBook\Lib;


use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferIncome(int $storeId, int $money,int $orderId)
 * @method  ResultInterface deferExpense(int $storeId, int $money,int $orderId)
 */
interface AccountInterface
{
    /**
     * 商家流水收入增加
     * @param $storeId
     * @param $money
     * @param $ordirId
     * @return bool
     */
    public function Income($storeId, $money, $ordirId);

    /**
     * 商家流水收入退款
     * @param $storeId
     * @param $money
     * @param $orderId
     * @return mixed
     */
    public function IncomeRefund($storeId, $money, $orderId);


    /**
     * 商家佣金增加
     * @param $storeId
     * @param $money
     * @param $orderId
     * @return mixed
     */
    public function AddBrokerage($storeId, $money, $orderId,$paystoreId=0);






    /**
     * 流水减少
     * @param $storeId
     * @param $money
     * @param $ordirId
     * @return bool
     */
    public function Expense($storeId, $money, $ordirId);
}