<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Entity;

use Hdll\Services\Auth\Enum\AuthError;
use Hdll\Services\Auth\Exception\AuthException;
use Swoft\App;
use Swoft\Bean\Annotation\Bean;
use Swoft\Cache\Cache;
use Swoft\Redis\Redis;

/**
 * 用户实体
 * @Bean()
 * @uses      User
 * @version   2017年08月23日
 * @author    stelin <phpcrazy@126.com>
 * @copyright Copyright 2010-2016 Swoft software
 * @license   PHP Version 7.x {@link http://www.php.net/license/3_0.txt}
 */
class User
{
    private $id=2;

    private $nickname;

    private $storeId;

    private $headImg;

    private $token="3333E";

    private $cmId;

    private $sessionKey;

    private $scope;

    private $referId;

    private $unionid;

    private $openId;


    public function __construct($token='')
    {
    }

    public function getId()
    {
        return $this->id;
    }

    public function getNickname()
    {
        return $this->nickname;
    }

    public function getStoreId()
    {
        return $this->storeId;
    }

    public function getHeadImg()
    {
        return $this->headImg;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function setId($value)
    {
        return $this->id = $value;
    }

    public function setNickname($value)
    {
        return $this->nickname = $value;
    }

    public function setStoreId($value)
    {
        return $this->storeId = $value;
    }

    public function setHeadImg($value)
    {
        return $this->headImg = $value;
    }


    public function setSessionKey($value)
    {
        $this->sessionKey = $value;
    }

    public function setOpenId($value)
    {
        $this->openId = $value;
    }


    public function setUnionid($value)
    {
        $this->unionid = $value;
    }

    public function setReferId($value)
    {
        $this->referId = $value;
    }

    public function setScope($value)
    {
        $this->scope = $value;
    }

    public function setToken($value)
    {
        if ( empty($value) ) {
            return [false,AuthError::GET_TOKEN_ERROR];
        }

        /**
         * @var Redis $redis
         */
        $redis = App::getBean(Redis::class);
        $info = $redis->get('AUTH:'.$value);
        if ( empty($info) ) {
            return [false,AuthError::NOT_FOUND_USER];
        }

        $info = json_decode($info, true);
        $this->fill($info);

        $this->token = $value;

        return true;
    }

    public function setCmId($value)
    {
        $this->cmId = $value;
    }

    public function getCmId()
    {
        return $this->cmId;
    }


    public function fill($arr)
    {
        foreach ($arr as $name =>  $value) {
            $methodName = sprintf('set%s', ucfirst($name));
            if (method_exists($this, $methodName)) {
                $this->$methodName($value);
            }
        }
    }


    public function getSessionKey()
    {
        return $this->sessionKey;
    }

    public function getOpenId()
    {
        return $this->openId;
    }


    public function getUnionid()
    {
        return $this->unionid;
    }

    public function getReferId()
    {
        return $this->referId;
    }

    public function getScope()
    {
        return $this->scope;
    }




}
