<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Insurance\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of insurance service
 *
 * @method ResultInterface deferGetOrderInfo(int $orderId)
 * @method ResultInterface deferPaySuccess(int $storeId, int $sellerId, $unionId, int $orderId)
 */
interface InsuranceInterface
{
    /**
     * 获取指定订单数据
     *
     * @param integer $orderId
     * @return array
     */
    public function getOrderInfo(int $orderId);

    /**
     * 支付成功回调
     *
     * @param integer $orderId
     * @return array
     */
    public function paySuccess(int $storeId, int $sellerId, $unionId, int $orderId);

}