<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/18
 * Time: 10:21
 */
namespace Hdll\Services\Common\Entity;

use Hdll\Services\Common\Bean\Collector\SplitCollector;
use Hdll\Services\Common\Enum\TestEnum;
use Hdll\Services\Common\Exception\CommonException;
use Swoft\App;
use Swoft\Core\RequestContext;
use Swoft\Db\Bean\Collector\EntityCollector;
use Swoft\Db\QueryBuilder;

class Split
{
    public static function initSplit($tableName, QueryBuilder $query)
    {
        $collector = SplitCollector::getCollector();//分表搜集器

        if ( $collector['map'] !== null && is_array($collector['map'])) {
            $map = array_flip($collector['map']);
        }

        if ( ! self::isTesting() ) {
            //如果是实体且为分表实体
            if (strpos($tableName, '\\') !== false && isset($collector[$tableName])) {
                $className = $tableName;
                $tableName = $collector[$tableName]['table'];

                $entityCollector = EntityCollector::getCollector();

                //设置分表对应的className
                EntityCollector::setCollector($tableName.'_'.self::getDbNum($className), $tableName);

                //获取分表名
                $tableName = $tableName.'_'.self::getDbNum($className);

                //设置分表类型
                $query->selectInstance($entityCollector[$className]['instance']);


            } elseif ( isset($map[$tableName]) ) { //非实体且分表
                $className = $map[$tableName];
                $defaultTbleName = $tableName;
                $tableName = $tableName.'_'.self::getDbNum($className);
                //设置分表对应的className
                EntityCollector::setCollector($tableName, $defaultTbleName);

            }

        }


        return $tableName;
    }

    private function getDbNum($className)
    {
        $splitCollector = SplitCollector::getCollector();
        $splitNum = $splitCollector[$className]['num'];
        $data = RequestContext::getContextData();
        $storeId = $data['userInfo']['storeId'];
        if ( empty($storeId) ) {
            throw new CommonException(["msg" => "参数异常，获取店铺信息失败。"]);
        }
        return $storeId % $splitNum;
    }

    private function isTesting()
    {
        /**@var User $user**/
        $user = App::getBean(User::class);

        return $user->getTestFlag() === TestEnum::TEST_STORE_ID;
    }
}