<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/12
 * Time: 13:44
 */
namespace Hdll\Services\Common\Bean\Collector;

use App\Bean\Annotation\Auth;
use Hdll\Services\Common\Bean\Annotation\Split;
use Swoft\Bean\CollectorInterface;

class SplitCollector implements CollectorInterface
{
    /**
     * @var array
     */
    private static $auth = [];

    public static function collect(string $className,
                                   $objectAnnotation = null,
                                   string $propertyName = '',
                                   string $methodName = '',
                                   $propertyValue = null)
    {
        if ($objectAnnotation instanceof Split) {

            $name = $objectAnnotation->getName();
            $scope = $objectAnnotation->getScope();

            self::$auth[$className]['name'] = $name;
            self::$auth[$className]['order'] = $scope;
            self::$auth['map'][$className] = $scope;
        }

        var_dump($className, $objectAnnotation, $propertyName, $methodName);
    }

    public static function getCollector()
    {
        return self::$auth;
    }

}