<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Order\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferSend(int $sendType, array $data, int $sendTime)
 */
interface NoticeInterface
{
    /**
     * 参数说明
     *
     * 微信发送消息数据结构
     * $data[NoticeEnum::MINI_BACKEND_SEND] = [
        "touser" => $openId,
        "template_id" => "1kZ_RkkWfRrpufXNdmJYBpIhgk7ccCtPrypeJQ9WRwM",
        "page" => "index",
        "form_id" => $formId,
        "data" => [
            "keyword1" => [
                "value" => "商品名称",
            ],
            "keyword2" => [
                "value" => "A8204427546131350100",
            ],
            "keyword3" => [
                "value" => "￥30",
            ],
            "keyword4" => [
                "value" => date('Y-m-d'),
            ]

        ]
    ];

     *
     * 短信发送消息数据结构
        $data[NoticeEnum::TENCENT_SMS] = [
            "templateId" => "178822", //模板id
            "phoneNumber" => "18812345678",
                "param" => [ //模板变量名
                "1580",
                "5"
            ]

        ];
     *
     * @param int $sendType
     * @param array $data
     * @param int $sendTime
     * @return mixed
     */
    public function send(int $sendType, array $data, int $sendTime);
}