<?php
namespace Hdll\Services\Common\Exception;

use Swoft\Exception\Exception;

class CommonException extends Exception
{
    // HTTP 状态码 404,200
    public $code = 500;

    // 错误具体信息
    public $message = '服务器异常';

    // 业务错误码
    public $errorCode = -1;

    public function __construct($params = [])
    {
        if(isset($params['code'])){
            $this->code = $params['code'];
        }

        if(isset($params['msg'])){
            $this->message = $params['msg'];
        }

        // 参数errCode 等效于 errorCode
        if(isset($params['errCode'])){
            $params['errorCode'] = $params['errCode'];
        }
        $this->errorCode = $params['errorCode'];

        parent::__construct($this->message, $this->code);
    }

    public function getErrcode(){
        return $this->errorCode;
    }

}