<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Order\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferCreateOrder(int $buyerId,int $storeId,int $consigneeId,int $itemId,int $selectedNum,int $orderType,int $total,int $activityPrice,string $goodsName,string $goodsImage,string $activityName,int $goodsId,int $goodsPrice,string $reservation_time = '',string $message = '');
 * @method ResultInterface deferGetOrderInfoBySn(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = [])
 * @method ResultInterface deferGetOrderInfo(int $storeId,int $orderId)
 * @method ResultInterface deferUpdateInfoById(int $storeId,int $orderId, array  $updateInfo)
 * @method ResultInterface deferGetSimpleList($storeId, $condition, $fields = ['*'])
 * @method ResultInterface deferUpdateInfoByIds(int $storeId,array $orderIds, array  $updateInfo)
 * @method ResultInterface deferCollectionClose(int $storeId, int $orderId)
 * @method ResultInterface deferGetOtherInfo(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = [])
 * @method ResultInterface deferGetList(int $storeId,array $ids)
 */
interface OrderInterface
{
    /**
     * 创建订单
     *
     * @param int $buyerId
     * @param int $storeId
     * @param int $consigneeId
     * @param int $itemId
     * @param int $selectedNum
     * @param int $orderType
     * @param int $total
     * @param int $activityPrice
     * @param string $goodsName
     * @param string $goodsImage
     * @param string $activityName
     * @param int $goodsId
     * @param int $goodsPrice
     * @param string $reservation_time
     * @param string $message
     * @return mixed
     */
    public function createOrder(
        int $buyerId,
        int $storeId,
        int $consigneeId,
        int $itemId,
        int $selectedNum,
        int $orderType,
        int $total,
        int $activityPrice,
        string $goodsName,
        string $goodsImage,
        string $activityName,
        int $goodsId,
        int $goodsPrice,
        string $reservation_time = '',
        string $message = ''
    );

    public function getOrderInfo(int $storeId,int $orderId);

    public function getOrderInfoBySn(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = []);

    public function updateInfoById(int $storeId,int $orderId, array  $updateInfo);

    public function closeOrder(int $storeId,int $orderId);

    /**
     * 获取订单数据
     * 字段值
     * `id`,
    `orderSn`,
    `paySn`,
    `orderType`  '订单类型：0普通商品，1活动',
    `storeId`, 店铺id
    `buyerId` ,买家id
    `itemId`  '0',
    `consigneeId` '付款人（收货人）ID，当线下订单时为空',
    `goodsAmount` ,
    `orderAmount`  '订单应付款',
    `actualAmount`  '订单实付款',
    `refundAmount`  '退款金额',
    `state`  '订单状态：0(已取消)10(默认):未付款;20:已付款;30:已发货/已预约;40:已收货/已核销;50-申请退款;60退款成功,70 已关闭,80,退款中,90,已评价',
    `refundState`  '0' COMMENT '退款状态:0是无退款,1是部分退款,2是全部退款',
    `refundMsg`'退款原因',
    `lockState`  '锁定状态:0是正常,大于0是锁定',
    `lockMsg`  '订单锁定原因',
    `balanceState`  '对账状态：0-未对账，1-已对账',
    `balanceTime` '对账时间',
    `message` ,
    `reservationTime`  ,
    `createTime`  创建时间,
    `updateTime`  更新时间,
    `deleteTime`  删除时间,
    `sellerId`   '卖家id',
    `deliveredTime`  '核销时间',
     *
     *
     * @param $storeId
     * @param $condition
     * @param array $fields
     * @return mixed
     */
    public function getSimpleList($storeId, $condition, $fields = ['*']);


    /**
     * 退款成功
     *
     * @param int $storeId
     * @param array $orderInfo
     * @return mixed
     */
    public function refundSuccess(int $storeId, array $orderInfo);

    /**
     * 拼团关闭订单，含退款
     *
     * @param int $storeId
     * @param int $orderId
     * @return mixed
     */
    public function collectionClose(int $storeId, int $orderId);

    /**
     * 批量更新
     *
     * @param int $storeId
     * @param array $orderIds
     * @param array $updateInfo
     * @return mixed
     */
    public function updateInfoByIds(int $storeId,array $orderIds, array  $updateInfo);

    /**
     * 获取订单联系人信息，item信息用
     *
     * @param int $storeId
     * @param string $orderSn
     * @param array $consigneeFields
     * @param array $itemFields
     * @return mixed
     */
    public function getOtherInfo(int $storeId, string $orderSn, array $consigneeFields = [], array $itemFields = []);


    /**
     * 批量获取订单信息
     *
     * @param int $storeId
     * @param array $ids
     * @return mixed
     */
    public function getList(int $storeId,array $ids);

}