<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/27
 * Time: 16:28
 */

namespace Hdll\Services\Seller\Lib;

use Swoft\Core\ResultInterface;

/**
 *
 * @method ResultInterface deferGetFund($seller)
 * @method ResultInterface deferAddBalance($seller, $money)
 * @method ResultInterface deferReduceBalance($seller, $money)
 * @method ResultInterface deferAddTotal($seller, $money)
 * @method ResultInterface deferReduceTotal($seller, $money)
 * @method ResultInterface deferAddExpectFund($seller, $money)
 * @method ResultInterface deferAddFund($seller, $money)
 * Interface SellerInterface
 * @package App\Lib
 */
interface SellerFundInterface
{


	/**
	 * 增加提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addBalance($seller, $money);

	/**
	 * 减少提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceBalance($seller, $money);

	/**
	 * 增加总提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addTotal($seller, $money);

	/**
	 * 减少总提现金额
	 * @param $seller
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function reduceTotal($seller, $money);

	/**
	 *
	 * @param $sellerId
	 * @return mixed
	 * totalFund   累计资金
	 * balanceFund 可提现金额
	 * commissionFund  需要支付的佣金
	 * expectFund  冻结金额
	 * totalWithdraw   累计提现
	 * @author Administrator
	 */
	public function getFund($sellerId);

	/**
	 * 增加冻结金额
	 * @param $sellerId
	 * @param $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addExpectFund($sellerId,$money);

	/**
	 * 增加金额
	 * @param $sellerId
	 * @param $balanceFund 可提现金额
	 * @param $commissionFund 佣金
	 * @return mixed
	 * @author Administrator
	 */
	public function addFund($sellerId, $balanceFund, $commissionFund);
}