<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of weapp service
 *
 * @method ResultInterface deferGetWxAccessToken(string $appId, string $appSecret)
 * @method ResultInterface deferGetMpQrcodeUrl(int $storeId, string $scene)
 */
interface WeappInterface
{
    /**
     * 根据appId获取对应的access_token
     * 
     * @param string $appId
     * @param string $appSecret
     * @return string
     */
    public function getWxAccessToken(string $appId, string $appSecret);
    
    /**
     * 生成公众号二维码
     *
     * @param string $storeId 店铺ID 
     * @param string $scene 通过小程序码传递的参数
     * @return string 成功返回二维码图片url
     */
    public function getMpQrcodeUrl(int $storeId, string $scene);
}