<?php

namespace Hdll\Services\Common\Config;

use Swoft\Redis\Redis;
use Swoft\App;

const CACHE_PREFIX = 'CONFIG_CACHE:';
$redis = App::getBean(Redis::class);
$data = $redis->get(CACHE_PREFIX . 'all');

if (empty($data)) {
	$db = CfgCenter::dbConnect();
	$arr = $db->select('config', ['name', 'value']);
	foreach ($arr as $key => $value) {
		$v_arr = json_decode($value['value'], true);
		$data[$value['name']] = empty($v_arr) ? $value['value'] : $v_arr;
	}
	$redis->set(CACHE_PREFIX . 'all', json_encode($data));
} else {
	$data = json_decode($data, true);
}
return $data;