<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Recharge\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferPayStatus(int $storeId, int $itemId, int $status, int $orderId)
 * @method  ResultInterface deferSpendCardMoney(int $storeId, int $buyerId, array $subOrders, int $parentOrderId)
 * @method  ResultInterface deferReturnCardMoney(int $storeId,int $buyerId,int $itemOrderId,string $itemTitle,int $payMoney, int $parentOrderId)
 * @method  ResultInterface deferStatisNum(int $storeId)
 */
interface RechargeInterface
{

    /**
     * 微信支付 状态 回馈接口
     * @param int $storeId
     * @param int $itemId   // 项目ID $localorderId
     * @param int $status   // BuyCardPayStatus::HAVE_PAY 成功支付  BuyCardPayStatus::PAY_EXCEPTION：未支付 （已经过期或者支付异常）
     * @param int $orderId   // 主订单id
     * @return mixed
     */
    public function payStatus(int $storeId, int $itemId, int $status, int $orderId);

    /**
     * 花费卡金额
     * @param int $storeId
     * @param int $buyerId
     * @param array $subOrders
     * $subOrders 示例：
     * [
     *     [
     *         'id' => 333, // 子订单id
     *         'itemName' => 'namenamename',  // 项目名
     *         'actualAmount' => 444,   // 项目价格
     *     ],
     *     [
     *         'id' => 555, 
     *         'itemName' => 'namenamename', 
     *         'actualAmount' => 666,
     *     ],
     * ]
     * @param int $parentOrderId  // 主订单id
     * @return mixed
     */
    public function spendCardMoney(int $storeId, int $buyerId, array $subOrders, int $parentOrderId);

    /**
     * 退回储值卡金额
     * @param int $storeId
     * @param int $buyerId
     * @param int $itemOrderId // 子订单
     * @param string $itemTitle // 项目名
     * @param int $payMoney // 项目价格
     * @param int $parentOrderId  // 主订单id
     * @return mixed
     */
    public function ReturnCardMoney(int $storeId, int $buyerId, int $itemOrderId, string $itemTitle, int $payMoney, int $parentOrderId);

    /**
     * 统计储值卡上架数/总数
     * @param int $storeId
     * @return mixed
     * 响应数据：
     * [
     *  'num' => 上架数,
     *  'total' => 总数
     * ]
     */
    public function statisNum(int $storeId);
}




 