<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/9
 * Time: 13:44
 */
namespace Hdll\Services\Pay\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferCreateOrder(int $storeId, int $orderId, int $openId)
 * @method ResultInterface deferGenerateSellerSign(int $storeId, int $orderId, string $openId)
 * @method ResultInterface deferRePay(int $storeId, int $orderId, int $buyerId)
 * @method ResultInterface deferSellerRePay(int $storeId, int $orderId, int $sellerId)
 * @method ResultInterface deferMpGenerateSign(int $storeId, int $orderId, int $sellerId)
 *
 * Interface PayInterface
 * @package Hdll\Services\Pay\Lib
 */
interface PayInterface
{
    /**
     * 买家生成签名
     *
     * @param int $storeId
     * @param int $orderId
     * @param string $openId
     * @return mixed
     */
    public function generateSign(int $storeId, int $orderId, string $openId);

    /**
     * 卖家生成签名
     *
     * @param int $storeId
     * @param int $orderId
     * @param string $openId
     * @return mixed
     */
    public function generateSellerSign(int $storeId, int $orderId, string $openId);

    /**
     * 公众号生成签名
     *
     * @param int $storeId
     * @param int $orderId
     * @param string $openId
     * @return mixed
     */
    public function mpGenerateSign(int $storeId, int $orderId, string $openId);

    


    /**
     * 卖家重新支付生成签名
     *
     * @param int $storeId
     * @param int $orderId
     * @param int $sellerId
     * @return mixed
     */
    public function sellerRePay(int $storeId, int $orderId, int $sellerId);

    /**
     * 买家重新支付，生成签名
     *
     * @param int $storeId
     * @param int $orderId
     * @param int $buyerId
     * @return mixed
     */
    public function rePay(int $storeId, int $orderId, int $buyerId);

}
