<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Wx3rd\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store service
 *
 * @method ResultInterface deferGetEntrustedData(int $storeId, array $fields = [])
 * @method ResultInterface deferGetWxpayCerts(int $storeId, $mchid)
 */
interface EntrustedInterface
{
    /**
     * 根据店铺id获取对应的托管配置
     * 
     * @param int $storeId
     * @param array $fields  字段列表
     * @return bool
     */
    public function getEntrustedData(int $storeId, array $fields = []);
    
    /**
     * 根据店铺id和商户平台id获取对应的支付证书
     * 
     * @param int $storeId
     * @param string $mchid
     * @return array
     */
    public function getWxpayCerts(int $storeId, $mchid);
}