<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Store\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of store-commission service
 *
 * @method ResultInterface deferGetWxAccessToken(int $appId, string $appSecret)
 */
interface WeappInterface
{
    /**
     * 根据appId获取对应的access_token
     * 
     * @Number(name="appId")
     * @param int $appId
     * @param string $appSecret
     * @return string
     */
    public function getWxAccessToken(int $appId, string $appSecret);
    
}