<?php
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://doc.swoft.org
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */
namespace Swoft\Db;

use Hdll\Services\Common\Entity\Split;

/**
 * Query
 */
class Query
{
    /**
     * Query查询分表处理
     * @param string $tableName
     * @param string|null $alias
     * @return QueryBuilder
     * @throws Exception\DbException
     */
    public static function table(string $tableName, string $alias = null): QueryBuilder
    {
        $query = new QueryBuilder();
        //初始化分表
        $tableName = Split::initSplit($tableName, $query);

        $query = $query->table($tableName, $alias);
        return $query;
    }


}
