<?php

namespace Hdll\Services\Common\ClsLogger;

use Monolog\Handler\AbstractProcessingHandler;
use Swoft\App;
use Swoole\Coroutine;

/**
 * 自定义日志处理器，记录到腾讯云Cls
 *
 * @uses      LogHandler
 */
class LogHandler extends AbstractProcessingHandler
{
    /**
     * @var array 输出包含日志级别集合
     */
    protected $levels = [];

    /**
     * @var string 对应腾讯CLS的主题ID
     */
    protected $topicId;

    /**
     * 批量输出日志
     *
     * @param array $records 日志记录集合
     *
     * @return bool
     */
    public function handleBatch(array $records)
    {
        $records = $this->recordFilter($records);
        if (empty($records)) {
            return true;
        }

        $lines = array_column($records, 'formatted');
        $this->write($lines);
    }

    /**
     * 输出到腾讯云CLS
     *
     * @param array $records 日志记录集合
     */
    protected function write(array $records)
    {
        $messageText = implode(" __||__ ", $records);

        if($this->topicId == ClsLog::TOPICID_ERROR) {
            ClsLog::error($messageText);
        } else if($this->topicId == ClsLog::TOPICID_NOTICE) {
            ClsLog::notice($messageText);
        }
    }

    /**
     * 记录过滤器
     *
     * @param array $records 日志记录集合
     *
     * @return array
     */
    private function recordFilter(array $records)
    {
        $messages = [];
        foreach ($records as $record) {
            if (!isset($record['level'])) {
                continue;
            }
            if (!$this->isHandling($record)) {
                continue;
            }

            $record = $this->processRecord($record);
            $search1 = strpos($record['messages'], '[http://testapi.2b3.cn:80/]');
            $search2 = strpos($record['messages'], '[http://api.2b3.cn:80/]');
            if($search1 !== false || $search2 !== false) {
                continue;
            }
            $record['formatted'] = $this->getFormatter()->format($record);

            $messages[] = $record;
        }
        return $messages;
    }

    /**
     * check是否输出日志
     *
     * @param array $record
     *
     * @return bool
     */
    public function isHandling(array $record)
    {
        if (empty($this->levels)) {
            return true;
        }

        return in_array($record['level'], $this->levels);
    }
}
