<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Coupon\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of coupon service
 *
 * @method ResultInterface deferCheckCoupon(int $buyerId, int $storeId, int $couponId, int $itemId)
 * @method ResultInterface deferGetCouponRecvdList(int $buyerId, int $storeId, int $subStoreId = 0, int $itemId = 0)
 * @method ResultInterface deferGetDataByCouponId(int $buyerId, int $storeId, int $couponId)
 */
interface CouponInterface
{
    // 优惠券服务的字段说明：
    // storeId       
    // subStoreId  
    // buyerId     买家ID
    // state       状态，1未使用，2已下单还未付款，3已使用过
    // couponId    当时领取的原始优惠券Id
    // couponName  当时领取的原始优惠券名字
    // parValue    优惠券面值
    // allowItems  优惠券允许使用的商品列表
    // addTime     领取时间
    // usedTime    被使用的时间

    /**
     * 校验优惠券是否可用
     *
     * @param integer $buyerId
     * @param integer $storeId
     * @param integer $couponId
     * @param integer $itemId
     * @return int|boolen 如果可用返回优惠券的面值，不可用返回false
     */
    public function checkCoupon(int $buyerId, int $storeId, int $couponId, int $itemId);

    /**
     * 更新优惠券状态
     *
     * @param integer $buyerId
     * @param integer $storeId
     * @param integer $couponId
     * @param integer $state 优惠券的状态
     * @return int 返回受影响的行数
     */
    public function updateCouponState(int $buyerId, int $storeId, int $couponId, int $state);

    /**
     * 获取顾客领取的优惠券列表
     *
     * @param integer $buyerId
     * @param integer $storeId
     * @param integer $subStoreId
     * @param integer $itemId
     * @return array
     */
    public function getCouponRecvdList(int $buyerId, int $storeId, int $subStoreId = 0, int $itemId = 0);


    /**
     * 根据优惠券ID获取信息
     *
     * @param integer $buyerId
     * @param integer $storeId
     * @param integer $couponId
     * @return array
     */
    public function getDataByCouponId(int $buyerId, int $storeId, int $couponId);

}