<?php
namespace Hdll\Services\Common\Lib;

use Swoft\App;
use Qcloud\Sms\SmsSingleSender;
use Hdll\Services\Common\Entity\User;

/**
 * (腾讯短信)手机验证码 工具类
 * 发送验证码： 
 * $err = (new Smscode)->send($mobile); // $mobile 接收验证码的手机号
 * if($err) {
 *     throw .... // 错误处理
 * }
 * 校验验证码：
 * $check = (new Smscode)->check($mobile,$smscode); // 前台传入的手机号和验证码
 * if(!$check) {
 *     throw .... // 错误处理
 * }
 * 
 */
class TencSmscode
{

    protected $uid;
    protected $config;

    public function __construct($uid = null)
    {
        if($uid !== null) {
            $this->uid = $uid;
        } else {
            $this->uid = App::getBean(User::class)->getId();
        }
        $commonConfigs = include dirname(__FILE__, 2).'/Config/config.php';
        $this->config = $commonConfigs['tencent_sms'];
    }

    /**
     * 发送验证码，可指定短信签名和使用哪个短信模块
     *
     * @param integer $mobile
     * @param [type] $signName
     * @param [type] $templateId
     * @return null|string  返回错误信息,正确时返回null
     */
    public function send(int $mobile, $signName = null, $templateId = null)
    {
        $key = $this->getKey($mobile);

        $val = cache()->get($key);
        if ($val) {
            list(, $time, $count) = explode(',', $val);
            if ($count >= 3) {
                return '验证码发送次数超限，请稍后再试';
            }
            if (time() - $time < 60) {
                return '发送验证码请求过于频繁';
            }
            $count += 1;
        } else {
            $count = 1;
        }
        $vcode = mt_rand(1000, 9999);
        $expireTime = 300; // 验证码有效期5分钟
        $params = [
            $vcode,
            $expireTime / 60
        ];
        $ssender = new SmsSingleSender($this->config['appid'], $this->config['appkey']);
        $result = $ssender->sendWithParam("86", $mobile, $templateId, $params, $signName);
        $result = json_decode($result, true);
        if ($result['result'] !== 0) {
            App::error("[发送腾讯云短信验证码失败]" . var_export($result, true) . "---param---{$mobile}," . json_encode($params));
            return '服务商返回错误';
        }
        $vdata = sprintf("%d,%d,%d,%d,%d", $vcode, time(), $count, $this->uid, $mobile);
        $result = cache()->set($key, $vdata, $expireTime);
        if (!$result) {
            return '验证码存储失败';
        }
    }

    /**
     * 校验验证码
     * 
     * @param integer $mobile
     * @param integer $smscode
     * @return bool 验证码正确时返回true
     */
    public function check(int $mobile, int $smscode)
    {
        $key = $this->getKey($mobile);
        $val = cache()->get($key);
        if ($val) {
            list($vcode,, ) = explode(',', $val);
            if ($vcode == $smscode) {
                return true;
            }
        }
        return false;
    }

    private function getKey($mobile)
    {
        return 'smscode:' . md5($this->uid . '|' . $mobile);
    }

}