<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/8
 * Time: 10:43
 */

namespace Hdll\Services\GroupBooking\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferPaySuccess($orderId)
 * @method ResultInterface deferHasActivity($storeId, $goodsId)
 * @method ResultInterface deferAdminCountActivity($storeId)
 * @method ResultInterface deferGetNewOrderNum($storeId, $time)
 * Interface GoodsInterface
 * @package Hdll\Services\Goods\Lib
 */
interface GroupBookingInterface
{


	public function paySuccess($orderId, $storeId);


	public function hasActivity($storeId, $goodsId);

	/**
	 * 关闭拼团
	 * @param $storeId
	 * @param $buyerId
	 * @param $orderId
	 * @return mixed
	 * @author Administrator
	 */
	public function closeRecord($storeId, $buyerId, $orderId);

	/**
	 * 获取所有活动数量
	 * [
	 *      'total'=>1,
	 *      'online'=>1
	 * ]
	 * @param $storeId
	 * @return mixed
	 * @author work
	 */
	public function adminCountActivity($storeId);


	/**
	 * 获取新订单数量
	 * @param $storeId
	 * @param $time
	 * @return mixed
	 * @author work
	 * @return number
	 */
	public function getNewOrderNum($storeId, $time);
}