<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/17
 * Time: 14:19
 */

namespace Hdll\Services\SellerDistribution\Enum;

class SellerDistributionError
{

	const E101 = [101, '店铺不存在'];
	const E102 = [102, '该数据不属于您', 403];
	const E103 = [103, '请勿重复创建', 403];
	const E104 = [104, '该用户不存在或属于您的团队', 403];
	const E105 = [105, '未开启分销', 200];
	const E106 = [106, '分销上级不存在', 404];

	public function getError($code)
	{
		$reflect = new \ReflectionClass(self::class);
		$arr = $reflect->getConstant('E' . substr($code, -3));
		if (!is_array($arr)) {
			return false;
		}
		return [
			'code' => $arr[0],
			'msg' => $arr[1],
			'errorCode' => $arr[2],
		];
	}
}