<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:48
 */

namespace Hdll\Services\BuyerDistribution\Lib;


/**
 * @method ResultInterface deferAddSellerFreezeMoney(int $storeId,int $money)
 * @method ResultInterface deferGetBuyerCommission(int $buyerId)
 * @method ResultInterface deferGetSellerFund(int $storeId)
 * @method ResultInterface deferSaveBill(string $token,int $order_id,int $buyer_id,int $store_id,string $order_sn,int $money)
 * Interface AgencyInterface
 * @package App\Lib
 */
interface BuyerDistributionInterface{


	/**
	 * 增加卖家冻结金额
	 * @param int $storeId
	 * @param int $money 冻结金额（千分）
	 * @return mixed
	 * @author Administrator
	 */
	public function addSellerFreezeMoney(int $storeId,int $money);

	/**
	 * 获取买家佣金数据
	 * @param int $buyerId
	 * @return mixed
	 * @author Administrator
	 */
	public function getBuyerCommission(int $buyerId);

	/**
	 * 获取卖家资金数据
	 * @param int $storeId
	 * @return mixed
	 * @author Administrator
	 */
	public function getSellerFund(int $storeId);

	/**
	 * 保存账单数据
	 * @param string $token
	 * @param int    $order_id
	 * @param int    $buyer_id
	 * @param int    $store_id
	 * @param string $order_sn
	 * @param int    $money
	 * @return mixed
	 * @author Administrator
	 */
	public function saveBill(
		string $token,
		int $order_id,
		int $buyer_id,
		int $store_id,
		string $order_sn,
		int $money
	);

	
}