<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Entity;

use Swoft\Bean\Annotation\Bean;

/**
 * 用户实体
 * @Bean()
 * @uses      User
 * @version   2017年08月23日
 * @author    stelin <phpcrazy@126.com>
 * @copyright Copyright 2010-2016 Swoft software
 * @license   PHP Version 7.x {@link http://www.php.net/license/3_0.txt}
 */
class User
{
    private $id;

    private $nickName;

    private $storeId;

    private $headImg;

    private $token;

    private $cmId;



    public function __construct($token='')
    {
        $this->setHeadImg("test");
        $this->setId(1);
        $this->setNickName("zhangsan");
        $this->setStoreId("2");
        $this->setToken($token);

    }

    public function getId()
    {
        return $this->id;
    }

    public function getNickName()
    {
        return $this->nickName;
    }

    public function getStoreId()
    {
        return $this->storeId;
    }

    public function getHeadImg()
    {
        return $this->headImg;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function setId($value)
    {
        return $this->id = $value;
    }

    public function setNickName($value)
    {
        return $this->nickName = $value;
    }

    public function setStoreId($value)
    {
        return $this->storeId = $value;
    }

    public function setHeadImg($value)
    {
        return $this->headImg = $value;
    }

    public function setToken($value)
    {
        return $this->token = $value;
    }

    public function setCmId($value)
    {
        $this->cmId = $value;
    }

    public function getCmId()
    {
        return $this->cmId;
    }

}
