<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/6
 * Time: 10:16
 */
namespace Hdll\Services\Common\Exception;

class ExceptionParseData
{
    public static function parseData(\Exception $e)
    {
        $exception = $e->getMessage();
        $pos = strpos($exception,"the return status of rpc is incorrected，data");
        if ( false !== $pos ) {
            $exception = str_replace("the return status of rpc is incorrected，data=","",$exception);

            $throw_data = json_decode($exception,true);
            $parse_data = explode(' ',$throw_data['msg']);

            $data = ['msg' => $parse_data[0], 'file' => $parse_data[1], 'line' => $parse_data[2], 'code' => $throw_data['status']];

        } else {
            $file      = $e->getFile();
            $line      = $e->getLine();
            $code      = $e->getCode();
            $exception = $e->getMessage();


            $data = ['msg' => $exception, 'file' => $file, 'line' => $line, 'code' => $code];
        }

        return $data;



    }

}