<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/20
 * Time: 11:13
 */
namespace Hdll\Services\Order\Enum;

class OrderError
{
    //common
    const PARAMETER_ERR = ["msg" => "参数错误", "code" => 400, "errorCode" => 22001];
    const PERMISSION_DENIED = ["msg" => "没有权限,%s", "code" => 401, "errorCode" => 22104];

    //validator
    const UNDEFINED_VALIDATOR = ["msg" => "未定义验证其验证器%s","code" => 500, "errorCode" => 22100];
    const EMPTY_COMPARE_VALUE = ["msg" => "对比数值不能为空", "code" => 500, "errorCode" => 22101];
    const UNKONW_OPERATION = ["msg" => "未知操作符%s", "code" => 500, "errorCode" => 22102];



    //联系人
    const NO_FOUND_CONSIGNEE = ["msg" => "未找到联系人信息", "code" => 404, "errorCode" => 22103];

    //预约
    const RESERVATION_OVERRUN = ["msg" => "预约时间不能早于当前时间", "code" => 400, "errorCode" => 22105];
    const RES_IS_REST = ["msg" => "休息日不能添加预约", "code" => 400, "errorCode" => 22106];

    //买家
    const FREEZE = ["msg" => "休息日不能添加预约", "code" => 400, "errorCode" => 22107];


    //order
    const O_PRICE_ABNORMAL = ["msg" => "价格异常，请重新购买", "code" => 400, "errorCode" => 22108];
    const O_TYPE_ERR = ["msg" => "订单类型不正确", "code" => 400, "errorCode" => 22109];
    const O_CREATE_ERR = ["msg" => "创建订单失败", "code" => 500, "errorCode" => 22110];
    const O_GOODS_SAVE_ERR = ["msg" => "商品订单存入失败", "code" => 500, "errorCode" => 22111];
    const O_CUT_PRICE_SAVE_ERR = ["msg" => "砍价订单存入失败", "code" => 500, "errorCode" => 22115];
    const O_NOT_FOUND = ["msg" => "订单不存在", "code" => 404, "errorCode" => 22116];
    const O_STATUS_ERR = ["msg" => "订单状态错误,无法操作", "code" => 400, "errorCode" => 22117];

    const DB_ERROR = ["msg" => "数据库操作错误", "code" => 500, "errorCode" => 22118];








    public static function atranslate($message,$param)
    {
        if ( empty($param) ) {
            return $message;
        }
        array_unshift($param,$message);
        return sprintf(...$param);
    }

}