<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:49
 */
namespace Hdll\Services\Common\Entity;

use Swoft\App;
use Swoft\Db\Bean\Collector\EntityCollector;
use Swoft\Db\Model;
use Swoft\Exception\Exception;

class CommonEntity extends Model
{

    private static $commentString;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        if ( false !== strpos(self::$commentString,"{split}") ) {
            $dbNum = self::getDbNum();
            self::setTableName($dbNum);

        }




        $this->init();

    }

    public function init()
    {

    }

    public static function getDb()
    {
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        if ( false !== strpos(self::$commentString,"{split}") ) {
            $dbNum = self::getDbNum();
            self::setTableName($dbNum);

        }

        return new static();
    }

    /**
     * 获取数据库id
     * @return int
     * @throws Exception
     */
    private static function getDbNum()
    {
        $user = App::getBean(User::class);

        $store = $user->getStoreId();
        if ( empty($store) ) {
            throw new Exception("店铺id获取失败");
        }

        return  $store % 100;

    }

    private static function setTableName($dbNum)
    {
        preg_match('/(?<=Table\(name=").*(?="\))/', self::$commentString, $matches);
        $tableName = isset($matches[0])?$matches[0]:'';

        EntityCollector::collect(
            static::class,
            new \Swoft\Db\Bean\Annotation\Table(['name' => $tableName.'_'.$dbNum])
        );

    }
}