<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Notice\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferSend(int $storeId, array $sendTypes, array $data, $sendTime, string $redisKey) :bool
 * @method ResultInterface deferCancelSend(string $redisKey):bool
 */
interface NoticeInterface
{
    /**
     * 参数说明
     *
     * 微信发送消息数据结构
     * $data[NoticeEnum::TYPE_MINI_BACKEND_SEND] = [
        "uid" => 1, //用户的id
     *  "storeId" => 1, //店铺id
        "template_id" => "1kZ_RkkWfRrpufXNdmJYBpIhgk7ccCtPrypeJQ9WRwM",//消息模板id
        "page" => "index", //消息模板页面
        "data" => [ //消息模板数据
            "keyword1" => [
                "value" => "商品名称",
            ],
            "keyword2" => [
                "value" => "A8204427546131350100",
            ],
            "keyword3" => [
                "value" => "￥30",
            ],
            "keyword4" => [
                "value" => date('Y-m-d'),
            ]

        ]
    ];

     *
     * 短信发送消息数据结构
    $data[NoticeEnum::TYPE_TENCENT_SMS] = [
        [
            'storeId' => 198
            "templateId" => "178822", //模板id
            "phoneNumber" => "17558430002",
            "param" => [ //模板变量名
                "1580",
                "5"
            ]
        ]
    ];
     *
     * 微信公众号发送实例
    $data[NoticeEnum::TYPE_MP_SEND] = [
        'unionId' => 'o3lFcs8xoWfQUlhzTiP5uZI6A7Hc', //填写用户的unionId
        'template_id' => 'zwUBuoKVRJkumLwGkippA46XfmLsmwJD906HC-wqOks',
        'miniprogram' => [
            'appid' => 'wx3b3b2df942634cdd', //小程序appid
            'pagepath' => 'pages/start/start'//小程序页面
        ],
        'data' => [
            'first' => 'first',
            'keyword1' => '姓名',
            'keyword2' => '1213456',
            'keyword3' => '测试门店',
            'keyword4' => '门店地址',
            'keyword5' => 'test',
            'remark' => 'remark'
        ]
    ];
     *
     * @param array $sendTypes
     * @param array $data
     * @param $sendTime   //发送时间，立即返送填0
     * @param string $redisKey   //发送事件的redis key（如果定时发送消息，中途需要取消则需要传入此项）
     * @return mixed
     */
    public function send(array $sendTypes, array $data,  $sendTime, string  $redisKey='') :bool;


    /**
     * 取消定时消息发送
     *
     * @param string $redisKey
     * @return bool
     */
    public function cancelSend(string $redisKey):bool ;
}