<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/11/5
 * Time: 16:26
 */
namespace Hdll\Services\Notice\Lib;

use Swoft\Core\ResultInterface;

/**
 * @method ResultInterface deferSendCode(string $phone, int $template, int $storeId, $validity=5,$num = 4, $sendTime=[]);
 * @method ResultInterface deferCheckCode(int $code, string $phone, int $template)
 *
 * Interface CaptchaInterface
 * @package Hdll\Services\Notice\Lib
 */
interface CaptchaInterface
{

    /**
     * @param string $phone 手机号
     * @param int $template 模板id
     * @param int $storeId 发送短信的id
     * @param int $validity 过期时间单位:分钟
     * @param int $num 验证码位数
     * @param array $sendTime 定时发送时间即时发送为[],定时发送格式为:[timestamp]
     * @return int 验证码code
     *
     */
    public function sendCode(string $phone, int $template, int $storeId, $validity=5,$num = 4, $sendTime=[]);

    /**
     * 验证验证码
     * @param int $code 验证码
     * @param string $phone 手机号
     * @param int $template 模板id
     * @return bool
     */
    public function checkCode(int $code, string $phone, int $template);

}