<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\Common\Pool\Config;

use Swoft\Bean\Annotation\Bean;
use Swoft\Bean\Annotation\Value;
use Swoft\Pool\PoolProperties;

/**
 * the config of service user
 *
 * @Bean()
 */
class BuyerPoolConfig extends PoolProperties
{
    /**
     * the name of pool
     *
     */
    protected $name = 'buyer';

    /**
     * Minimum active number of connections
     *
     */
    protected $minActive = 5;

    /**
     * the maximum number of active connections
     *
     */
    protected $maxActive = 50;

    /**
     * the maximum number of wait connections
     *
     */
    protected $maxWait = 100;

    /**
     * Maximum waiting time
     *
     */
    protected $maxWaitTime = 3;

    /**
     * Maximum idle time
     *
     */
    protected $maxIdleTime = 60;

    /**
     * the time of connect timeout
     *
     */
    protected $timeout = 5;

    /**
     * the addresses of connection
     *
     * <pre>
     * [
     *  '127.0.0.1:88',
     *  '127.0.0.1:88'
     * ]
     * </pre>
     *
     */
    protected $uri = [
        "192.168.3.100:8101"

    ];

    /**
     * whether to user provider(consul/etcd/zookeeper)
     *
     */
    protected $useProvider = false;

    /**
     * the default balancer is random balancer
     *
     */
    protected $balancer = '';

    /**
     * the default provider is consul provider
     *
     */
    protected $provider = '';
}
