<?php
/**
 * 买家佣金提现接口
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */
namespace Hdll\Services\WithdrawCash\Lib;
use Swoft\Core\ResultInterface;

/**
 * The interface of WithdrawCashInterface service
 *
 * @method ResultInterface deferPaySuccess(int $type,int $storeId,int $id,string $wxOrderSn,int $fee)
 * @method ResultInterface deferPayFailed(int $type,int $storeId,int $id,string $message)
 */
interface WithdrawCashInterface{
    /**
     * 支付成功接口
     *
     * @param integer $type         提现类型
     * @param integer $storeId      店铺ID
     * @param integer $id           提现记录ID
     * @param string  $wxOrderSn    微信支付订单号
     * @param integer $fee          手续费
     * @return boolean
     */
    public function paySuccess(int $type,int $storeId,int $id,string $wxOrderSn,int $fee);

    /**
     * 支付失败接口
     *
     * @param integer $type         提现类型
     * @param integer $storeId      店铺ID
     * @param integer $id           提现记录ID
     * @param string $message       失败信息
     * @return boolean
     */
    public function payFailed(int $type,int $storeId,int $id,string $message);
}