<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\AccountBook\Lib;


use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferIncome(int $storeId, int $money,int $orderId)
 * @method  ResultInterface deferExpense(int $storeId, int $money,int $orderId)
 */
interface AccountInterface
{
    /**
     * 流水增加
     * @param $storeId
     * @param $money
     * @param $ordirId
     * @return bool
     */
    public function Income($storeId, $money, $ordirId);

    /**
     * 流水减少
     * @param $storeId
     * @param $money
     * @param $ordirId
     * @return bool
     */
    public function Expense($storeId, $money, $ordirId);
}