<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/10/9
 * Time: 9:22
 */
namespace Hdll\Services\Notice\Extensions;

use Hdll\Services\Notice\Extensions\Notice\SenderInterface;
use Hdll\Services\Notice\Lib\NoticeInterface;

class NoticeExtension
{
    private $notice;

    public function __construct(NoticeInterface $notice)
    {
        $this->notice = $notice;
    }

    /**
     * 发送消息通知
     *
     * @param int $sendTime
     * @param mixed ...$senders
     * @return bool|mixed
     */
    public function send(int $sendTime, ... $senders)
    {

        $data = [];
        $sendType = [];

        foreach ( $senders as $sender ) {
            if ( ! $sender instanceof SenderInterface) {
                continue;
            }
            if ( in_array($sender->getSendType(), $sendType) ) {
                continue;
            }

            $sender->format();
            $data += $sender->getData();

            $sendType += $sender->getSendType();


        }

        return $this->notice->send($sendType, $data, $sendTime);
    }
}