<?php
namespace Hdll\Services\Common\Config;
use Swoft\Redis\Redis;
use Swoft\App;

class CfgCenter
{

    /**
     * 读取指定的配置项
     * (所有配置项，需预先添加到数据库中)
     * 方法一：
     *  $value = CfgCenter::get('qCloud>Weapp>Region');
     *  var_dump($value); // 输出：ap-shanghai
     * 方法二：
     *  $cfgdata = CfgCenter::get('qCloud');
     *  var_dump($cfgdata->Weapp->Region); // 输出：ap-shanghai
     * 
     * @param string $keyStr
     * @return mixed
     */
    public static function get($keyStr)
    {
        $keyArr = self::parseKeyStr($keyStr);
        $rkey = implode(":", $keyArr);
        $redis = App::getBean(Redis::class);
        $data = $redis->get("CONFIG_CENTER:".$rkey);
        if($data === null) {
            $res = self::dbFetch($keyStr);
            if($res) {
                if(is_object($res[1])) {
                    $val = json_encode($res[1]);
                } else {
                    $val = $res[1];
                }
                $redis->set("CONFIG_CENTER:".$res[0], $val);
                return $res[1];
            }
        }
        $obj = json_decode($data);
        if($obj && is_object($obj)) {
            return $obj;
        }
        return $data;
    }

    protected static function dbFetch($keyStr)
    {
        $keyArr = self::parseKeyStr($keyStr);
        $name = array_shift($keyArr);
        $result = self::dbConnect()->select("config", ['name','value'], ['name'=>$name]);
        if(!isset($result[0]['value'])) {
            return;
        }
        $valObj = json_decode($result[0]['value']);
        if(!is_object($valObj)) {
            return;
        }
        $keys = '';
        foreach($keyArr as $key) {
            if(!isset($valObj->$key)) {
                break;
            }
            $keys .= $key.':';
            $valObj = $valObj->$key;
        }
        $rkey = $name.':'.trim($keys,':');
        return [$rkey, $valObj];
    }

    protected static function dbConnect()
    {
        // 返回数据库连接
        return new \Medoo\Medoo([
            'database_type' => 'mysql',
            'database_name' => 'config_center',
            'server' => '192.168.3.202',
            'username' => 'hdller',
            'password' => 'Hdlltest888',
            'charset' => 'utf8'
        ]);
    }

    protected static function parseKeyStr($keyStr)
    {
        $keyArr = explode(">", trim($keyStr, '>'));
        foreach($keyArr as $k => $v) {
            $v = trim($v);
            if($v == "") {
                unset($keyArr[$k]);
            } else {
                $keyArr[$k] = $v;
            }
        }
        if(empty($keyArr)) {
            throw new \Exception("[CfgCenter]未指定合法的Key");
        }
        return $keyArr;
    }
}

