<?php

namespace Hdll\Services\Common\ClsLogger;

class ClsSignature
{
    public static function create(){
        
        $signTime = (time()-10).';'.(time()+300);
        $configs = include dirname(__FILE__, 2).'/Config/config.php';

        $sha1edHttpString = sha1("post\n/structuredlog\n\n\n"); 
        $stringToSign = "sha1\n{$signTime}\n{$sha1edHttpString}\n"; 
        $signKey = hash_hmac('sha1', $signTime, $configs['cls']['secretKey']); 
        $signature = hash_hmac('sha1', $stringToSign, $signKey);
        $authorization = 'q-sign-algorithm=sha1&q-ak='.$configs['cls']['secretId']
                         ."&q-sign-time={$signTime}&q-key-time={$signTime}&q-header-list=&q-url-param-list=&q-signature={$signature}";
        return $authorization;
    }
}
