<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:49
 */
namespace Hdll\Services\Common\Entity;

use Hdll\Services\Common\Bean\Collector\SplitCollector;
use Swoft\App;
use Swoft\Core\RequestContext;
use Swoft\Db\Bean\Collector\EntityCollector;
use Swoft\Db\Model;
use Swoft\Exception\Exception;
use Swoole\Http\Request;

class CommonEntity extends Model
{

    private static $commentString;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();
        //分表逻辑
        $this->split();

        $this->init();

    }

    /**
     * 初始化
     */
    public function init()
    {

    }

    public static function getDb()
    {
        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        self::$commentString = $res->getDocComment();

        //分表逻辑
        self::split();


        return new static;
    }

    /**
     * 设置分表表名
     * @throws Exception
     */
    protected function split()
    {
        if (  empty(RequestContext::getContextData()) ) {//初始化不做处理
            return;
        }


        if ( false === strpos(self::$commentString,"{split}") || App::$isInTest ) {
            return;
        }

        $dbNum = self::getDbNum();
        $tableName = self::getTableName();

        self::setTableName($tableName.'_'.$dbNum);

    }

    /**
     * 获取分库表名
     *
     * @return string
     * @throws Exception
     * @throws \ReflectionException
     */
    public static function tableName()
    {

        if (  empty(RequestContext::getContextData()) ) {//初始化不做处理
            return;
        }

        //获取注解里的table
        $res = new \ReflectionClass(static::class);
        $commentString = $res->getDocComment();

        if (
        (
            false !== strpos($commentString,"{split}")
            || false !== strpos($commentString,"@Split")
        )
            &&  !App::$isInTest) {
            $dbNum = self::getDbNum();
            $tableName = self::getTableName($commentString).'_'.$dbNum;
            //self::setTableName($tableName);
        } else {
            $tableName = self::getTableName($commentString);
        }

        $newTableName = self::newTableName();

        if ( $tableName != $newTableName ) { //校验新的分表规则
            App::error("[新分表异常][对比失败]oldFunction".$tableName.'new function'.$newTableName);
        }

        return $tableName;


    }

    private static function newTableName()
    {
        if (  empty(RequestContext::getContextData()) ) {//初始化不做处理
            return;
        }

        $entityCollector = EntityCollector::getCollector();
        $splitCollector = SplitCollector::getCollector();//分表搜集器

        $className = static::class;
        $tableName = $entityCollector[$className]['table']['name'];

        if ( isset($splitCollector[$className]) ) { //分表
            $dbNum  = (new Split())->getDbNum($className);
            $tableName = $tableName.'_'.$dbNum;
        }

        return $tableName;
    }

    /**
     * 获取数据库id
     * @return int
     * @throws Exception
     */
    private static function getDbNum()
    {
        $user = App::getBean(User::class);

        $store = $user->getStoreId();
        if ( $store === null && $store === [] && $store === '' ) {
            throw new Exception("店铺id获取失败");
        }

        $splitCollector = SplitCollector::getCollector();
        $splitNum = $splitCollector[static::class]['num'];

        return  $store % $splitNum;

    }

    /**
     * 设置表名
     * @param $dbNum
     */
    protected static function setTableName($tableName)
    {
        EntityCollector::collect(
            static::class,
            new \Swoft\Db\Bean\Annotation\Table(['name' => $tableName])
        );

    }

    /**
     * 获取原始表名
     * @return string
     */
    protected static function getTableName($commentString = '')
    {
        $commentString = $commentString === ''?self::$commentString:$commentString;
        preg_match('/(?<=Table\(name=").*(?="\))/', $commentString, $matches);
        return $tableName = isset($matches[0])?$matches[0]:'';
    }
}