<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\CustomerProfiles\Lib;


use App\Exception\ConException;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferAddOrder($storeId, $orderId, $goodsId, $goodsName, $orderPrice, $orderType, $orderTime, $consigneeName, $consigneePhone, $buyerId,$activityName)
 * @method  ResultInterface deferSinceAddVisitor(int $storeId, int $buyerId, int $time)
 * @method  ResultInterface deferGetProfile($storeId, $buyerId)
 */
interface ProfileInterface
{
    /**
     * 档案和消费信息入库
     * @param $storeId
     * @param $orderId
     * @param $goodsId
     * @param $goodsName
     * @param $orderPrice
     * @param $orderType
     * @return mixed
     */
    public function AddOrder($storeId, $orderId, $goodsId, $goodsName, $orderPrice, $orderType, $orderTime, $consigneeName, $consigneePhone, $buyerId,$activityName);

    /**
     * 自增加顾客档案访问数和最近访问时间戳
     * @param int $storeId // 店铺id
     * @param int $buyerId // 买家id
     * @param int $time // 访问时间
     * @return mixed
     */
    public function sinceAddVisitor(int $storeId, int $buyerId, int $time);

    /**
     * 获取买家信息
     * @param $storeId  // 店铺id
     * @param $buyerId  // 卖家id
     * @return mixed
     */
    public function getProfile($storeId, $buyerId);

	/**
	 * 店员统计信息
	 * @param $storeId
	 * @param $cmanId
	 * @param $starTime
	 * @param $endTime
	 * @return mixed
	 */
	public function cmanCount($storeId,$cmanId,$starTime,$endTime);

}