<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/12
 * Time: 13:44
 */
namespace Hdll\Services\Common\Bean\Collector;

use App\Bean\Annotation\Auth;
use Swoft\Bean\CollectorInterface;

class AuthCollector implements CollectorInterface
{
    /**
     * @var array
     */
    private static $auth = [];

    public static function collect(string $className,
                                   $objectAnnotation = null,
                                   string $propertyName = '',
                                   string $methodName = '',
                                   $propertyValue = null)
    {
        if ($objectAnnotation instanceof Auth) {
            $scope = $objectAnnotation->getScope();
            $option = $objectAnnotation->getOption();
            if ( $methodName ==='' ) {
                self::$auth[$className]['scope'] = $scope;
                self::$auth[$className]['option'] = $option;
            } else {
                self::$auth[$className]['methods'][$methodName]['scope'] = $scope;
                self::$auth[$className]['methods'][$methodName]['option'] = $option;
            }



        }

    }

    public static function getCollector()
    {
        return self::$auth;
    }

}