<?php

/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

 

namespace Hdll\Services\SMS\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of SMS service
 *
 * @method ResultInterface deferCreateCost(int $storeId,string $scene,int $decnum,string $nickname,string $phone)
 * @method ResultInterface deferPayOrder(string $orderNo,int $payStatus) 
 * @method ResultInterface deferGetOrder(int $storeId,int $smsOId)
 */
interface SMSInterface
{ 
    /**
     * 消费短信
     *
     * @param integer $storeId
     * @param string $scene
     * @param integer $decnum
     * @param string $nickname
     * @param string $phone
     * @return int
     */
    public function createCost(int $storeId,string $scene,int $decnum,string $nickname,string $phone);




    /**
     * 支付短信套餐包订单
     *
     * @param string $orderNo
     * @param integer $payStatus
     * @return int
     */
    public function payOrder(string $orderNo,int $payStatus);

     /**
     * 获取短信订单
     * @param integer $storeId
     * @param integer $smsOId
     * @return array
     */
    public function getOrder(int $storeId,int $smsOId);
    
}
