<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/20
 * Time: 11:13
 */
namespace Hdll\Services\Buyer\Enum;

class BuyerError
{
    const PARAMETER_ERR = ["msg" => "参数错误", "code" => 400, "errorCode" => 24001];
    const REGISTERED = ["msg" => "用户已存在,无需创建", "code" => 400, "errorCode" => 24101];
    const DB_ERROR = ["msg" => "数据库操作错误", "code" => 500, "errorCode" => 24102];
    const SCORE_ERR = ["msg" => "你无权创建该用户", "code" => 403, "errorCode" => 24103];


    public static function atranslate($message,$param)
    {
        if ( empty($param) ) {
            return $message;
        }
        array_unshift($param,$message);
        return sprintf(...$param);
    }

    public static function getError($code) {
        $reflect = new \ReflectionClass(BuyerError::class);
        return $reflect->getConstant('E'.$code);
    }

}