<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/10
 * Time: 14:53
 */
namespace Hdll\Services\Notice\Extensions\Notice;

use Hdll\Services\Notice\Enum\NoticeEnum;

class TencentSMS implements SenderInterface
{
    private $sendType = NoticeEnum::TYPE_TENCENT_SMS;

    private $data;

    private $phone;

    private $template;

    private $param;

    private $storeId;

    public function __construct(string $phone, string $template, array $param, int $storeId)
    {
        $this->phone = $phone;
        $this->template = $template;
        $this->param = $param;
        $this->storeId = $storeId;
    }

    public function format()
    {
        $this->data[$this->sendType] = [
            [
                'storeId'     => $this->storeId,
                'templateId'  => $this->template,
                'phoneNumber' => $this->phone,
                'param'       => $this->param,
            ]
        ];

    }

    public function getData()
    {
        return $this->data === null?[]:$this->data;
    }

    public function getSendType()
    {
        return [$this->sendType];
    }


}