<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\LimitTimeBuy\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferBackNum(string $token, int $consignee_id, int $limit_id, int $selected_num, int $order_type, int $goods_id, string $reservation_time = '')

 */
interface LimitTimeBuyInterface
{
    /**
     *
     * 补回  未支付 限购活动  库存
     * @param string $token
     * @param int $consignee_id
     * @param int $limit_id
     * @param int $selected_num
     * @param int $order_type
     * @param int $goods_id
     * @param string $reservation_time
     * @return mixed
     */
    public function backNum(
        string $token,
        int $consignee_id,
        int $limit_id,
        int $selected_num,
        int $order_type,
        int $goods_id,
        string $reservation_time = '');
    /**
     *  获取限时购商品的 商品信息
     * @param int $limit_id
     * @return mixed
     */
    public function getLimitgoods(
        int $sellerId,int $limitId
    );

}