<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/7/2
 * Time: 13:48
 */

namespace Hdll\Services\BuyerDistribution\Lib;
use Swoft\Core\ResultInterface;


/**
 * @method ResultInterface deferGetSetting(string $token)
 * @method ResultInterface deferPutSetting(string $token,array $param)
 * @method ResultInterface deferGetTeam(string $token,int $pid,int $page)
 * @method ResultInterface deferSaveAgencyBill(string $token,array $order)
 * Interface AgencyInterface
 * @package App\Lib
 */
interface AgencyInterface{

	/**
	 * 获取分销设置
	 * @return mixed
	 * @author Administrator
	 */
	public function getSetting(string $token);

	/**
	 * 写入或更新分销设置
	 * @param array $param
	 * @return mixed
	 * @author Administrator
	 */
	public function putSetting(string $token,array $param);


	/**
	 * 获取团队列表
	 * @param $pid
	 * @param $page
	 * @return mixed
	 * @author Administrator
	 */
//	public function getTeam(string $token,int $pid,int $page);

	/**
	 * 保存分销账单
	 * @param array $order 订单数据
	 * @return mixed
	 * @author Administrator
	 */
	public function saveAgencyBill(string $token,array $order);

	/**
	 * 增加卖家冻结金额
	 * @param string $token
	 * @param int    $money
	 * @return mixed
	 * @author Administrator
	 */
	public function addSellerFreezeMoney(string $token,int $money);

	/**
	 * 获取买家佣金数据
	 * @param string $token
	 * @return mixed
	 * @author Administrator
	 */
	public function getBuyerCommission(string $token);

	/**
	 * 获取卖家资金数据
	 * @param string $token
	 * @return mixed
	 * @author Administrator
	 */
	public function getSellerFund(string $token);

	/**
	 * 保存账单数据
	 * @param string $token
	 * @param int    $order_id
	 * @param int    $buyer_id
	 * @param int    $store_id
	 * @param string $order_sn
	 * @param int    $money
	 * @return mixed
	 * @author Administrator
	 */
	public function saveBill(
		string $token,
		int $order_id,
		int $buyer_id,
		int $store_id,
		string $order_sn,
		int $money
	);

	
	public function getBillList(string $token,array $condition, int $page, int $limit = 15);
}