<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\LimitTimeBuy\Lib;

use Hdll\Services\LimitTimeBuy\Enum\LimitTimeOrderEnum;
use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method  ResultInterface deferIncome(string $token, int $consignee_id, int $limit_id, int $selected_num, int $order_type, int $goods_id, string $reservation_time = '')
 */
interface AccountInterface
{
    /**
     * 流水增加
     * @param $storeId
     * @param $money
     * @param $orderId
     * @return bool
     */
    public function Income(int $storeId, int $money,int $orderId);
    /**
     * 流水减少
     * @param $storeId
     * @param $money
     * @param $orderId
     * @return bool
     */
    public function Expense(int $storeId, int $money, int $orderId);
}