<?php
/**
 * This file is part of Swoft.
 *
 * @link https://swoft.org
 * @document https://doc.swoft.org
 * @contact group@swoft.org
 * @license https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace Hdll\Services\FlowMetering\Lib;

use Swoft\Core\ResultInterface;

/**
 * The interface of demo service
 *
 * @method ResultInterface deferOrderMark(string $token, int $orderType, int $orderId, float $money)

 */
interface FlowMeteringInterface
{
    /**
     * @param string $token
     * @param int $orderType
     * @param int $orderId
     * @param float $money
     * @return mixed
     */

    public function OrderMark(
        string $token,
        int $orderType,
        int $orderId,
        float $money);
}